/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks;

import com.shynieke.statues.blockentities.AbstractStatueBlockEntity;
import com.shynieke.statues.blockentities.StatueBlockEntity;
import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.init.StatueBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractStatueBase
extends AbstractBaseBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final BooleanProperty INTERACTIVE = BooleanProperty.m_61465_((String)"interactive");

    public AbstractStatueBase(BlockBehaviour.Properties builder) {
        super(builder.m_60978_(0.6f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INTERACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult result) {
        if (!level.f_46443_ && handIn == InteractionHand.MAIN_HAND && this.canPlaySound(level, pos, state)) {
            level.m_5594_(null, pos, this.getSound(state), SoundSource.NEUTRAL, 1.0f, this.getPitch());
        }
        if (((Boolean)state.m_61143_((Property)INTERACTIVE)).booleanValue() && handIn == InteractionHand.MAIN_HAND && !level.f_46443_ && this.getTE((BlockGetter)level, pos) != null) {
            this.executeStatueBehavior(this.getTE((BlockGetter)level, pos), state, level, pos, playerIn, handIn, result);
        }
        return InteractionResult.SUCCESS;
    }

    public StatueBlockEntity getTE(BlockGetter getter, BlockPos pos) {
        return getter.m_7702_(pos) instanceof StatueBlockEntity ? (StatueBlockEntity)getter.m_7702_(pos) : null;
    }

    public void executeStatueBehavior(StatueBlockEntity blockEntity, BlockState state, Level level, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult result) {
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)INTERACTIVE)).booleanValue()) {
            return new StatueBlockEntity(pos, state);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (((Boolean)state.m_61143_((Property)INTERACTIVE)).booleanValue()) {
            return AbstractStatueBase.createStatueTicker(level, blockEntityType, (BlockEntityType<? extends AbstractStatueBlockEntity>)((BlockEntityType)StatueBlockEntities.STATUE.get()));
        }
        return null;
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createStatueTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends AbstractStatueBlockEntity> blockEntityType1) {
        return level.f_46443_ ? null : AbstractStatueBase.m_152132_(blockEntityType, blockEntityType1, AbstractStatueBlockEntity::serverTick);
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        CompoundTag compoundnbt;
        ItemStack itemstack = super.m_7397_(getter, pos, state);
        StatueBlockEntity statueBlockEntity = this.getTE(getter, pos);
        if (statueBlockEntity != null && ((Boolean)state.m_61143_((Property)INTERACTIVE)).booleanValue() && !(compoundnbt = statueBlockEntity.saveToNbt(new CompoundTag())).m_128456_()) {
            itemstack.m_41700_("BlockEntityTag", (Tag)compoundnbt);
        }
        return itemstack;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, INTERACTIVE});
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            super.m_6810_(state, level, pos, newState, isMoving);
            level.m_46747_(pos);
        }
    }

    public boolean canBeUpgraded() {
        return true;
    }

    public boolean isHiddenStatue() {
        return false;
    }

    public boolean isBaby() {
        return false;
    }

    public EntityType<?> getEntity() {
        return EntityType.f_20483_;
    }

    public String getLootName() {
        return "baby_zombie";
    }

    public SoundEvent getSound(BlockState state) {
        return SoundEvents.f_11668_;
    }

    public float getPitch() {
        return this.isBaby() ? (this.RANDOM.nextFloat() - this.RANDOM.nextFloat()) * 0.2f + 1.5f : (this.RANDOM.nextFloat() - this.RANDOM.nextFloat()) * 0.2f + 1.0f;
    }

    public boolean canPlaySound(Level worldIn, BlockPos pos, BlockState state) {
        StatueBlockEntity statueBlockEntity;
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        boolean flag = (Boolean)state.m_61143_((Property)INTERACTIVE) != false && blockEntity instanceof StatueBlockEntity && (statueBlockEntity = (StatueBlockEntity)blockEntity).makesSounds();
        boolean flag2 = worldIn.m_8055_(pos.m_7495_()).m_60734_() instanceof NoteBlock;
        return flag || flag2;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.f_46443_ && this.canPlaySound(worldIn, pos, state) && worldIn.m_46753_(pos)) {
            worldIn.m_5594_(null, pos, this.getSound(state), SoundSource.NEUTRAL, 1.0f, (worldIn.f_46441_.nextFloat() - worldIn.f_46441_.nextFloat()) * 0.2f + 1.5f);
        }
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
    }
}

